  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Jan 12 12:16:55 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_Ext_ATP_ECC_Acceptance.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/************* Include Files ****************/ 
#include "CRYS.h"
 
#include "CRYS_Ext_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_Ext_ATP_ECC_Acceptance.h"
#include "CRYS_Ext_ATP_ECC_Acceptance_test_vectors.h"
#include "CRYS_HOST_TST_ECC.h"


#include "DX_VOS_Mem.h"
#include "math.h"
#include <stdio.h>


/************************ Defines ************************/
/************************ Enums **************************/
/************************ Typedefs ***********************/
/************************ Global Data ********************/
extern char FailureFunctionNameOut[FailureFunctionName_K_Size];
/***** Private function prototype ******/
/******** Public Functions **********/

/************* Private function prototype ****************/
/************************ Private Functions **************/
/************************ Public Functions ***************/
/*****************************************************************************
* Function Name:                                                           
*  CRYS_ExtApp_ATP_ECC_ECDSA_NonIntegratedSignVerify      
*  
* Inputs:
* 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for ECC ESDSA Sign & Verify function,
*  implemented as external SEP application  
* Algorithm:       
* 1. Call the SEPQA_ECC_ECDSA_NonIntegratedSignVerify function to execute test
* 2. Verify function succeded according to the returned error code
*
******************************************************************************/                                
CRYSError_t CRYS_ExtApp_ATP_ECC_ECDSA_NonIntegratedSignVerify  ( int TST_KeyGeneration_TestStatus )
{
     CRYSError_t                            TST_TestStatus=0;
     int                                    TST_index = 0;
	 int                                    TST_KeyGenType;
	 
     char       TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ExtApp_ATP_ECC_ECDSA_NonIntegratedSignVerify"; 

     /* Setting if to use internal key generation */
     if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
         TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
     else
         TST_KeyGenType = TST_INTERNAL_KG;

     for (; TST_KeyGenType <2 ; TST_KeyGenType++) /*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/ 
     {
          #ifdef DX_SEP_G3_VER_ONE
            if(TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_CRYS_ECPKI_DomainID != CRYS_ECPKI_DomainID_secp256r1)
              continue;
          #endif
        
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s[test 1.%d]\n",SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name,TST_index));  
            if (TST_KeyGenType == TST_INTERNAL_KG)
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Internal Key Generation  \n"));
            else
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," External Keys  \n"));                        
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n"));

			TST_ATP_Error = SEPQA_ECC_ECDSA_NonIntegratedSignVerify(
							TST_KeyGenType,
							SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_CRYS_ECPKI_DomainID,
							SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPublKey,
							SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPublKeySize,
							SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPrivKey,
							SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPrivKeySize,
							SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_HashMode,
							SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_input_data,
							SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_input_dataSize,
							SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_SignitureSize,
							FailureFunctionNameOut,
							FailureFunctionName_K_Size);

			TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_ECC_ECDSA_NonIntegratedSignVerify",FailureFunctionNameOut,TST_MasterTestName);                   
     }/* End of TST_KeyGenType loop*/
     return TST_TestStatus;
}/*End of CRYS_ATP_TST_ECC_Acceptance_ECDSA_NonIntegratedSignVerify*/

/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/
/*****************************************************************************
* Function Name:                                                           
*  CRYS_ExtApp_ATP_ECC_ECDSA_IntegratedSignVerify      
*  
* Inputs:
* 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for ECC ESDSA Sign & Verify,
*  implemented as external SEP application  
* Algorithm:       
* 1. Call the SEPQA_ECC_ECDSA_NonIntegratedSignVerify function to execute test
* 2. Verify function succeded according to the returned error code
*
******************************************************************************/                                
CRYSError_t CRYS_ExtApp_ATP_ECC_ECDSA_IntegratedSignVerify  ( int TST_KeyGeneration_TestStatus )
{
     CRYSError_t                            TST_TestStatus=0;
     int                                    TST_index = 0,TST_KeyGenType;
     char       TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ExtApp_ATP_ECC_ECDSA_IntegratedSignVerify"; 

     /* Setting if to use internal key generation */
     if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
         TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
     else
         TST_KeyGenType = TST_INTERNAL_KG;

     for (; TST_KeyGenType <2 ; TST_KeyGenType++) /*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/ 
     {
          #ifdef DX_SEP_G3_VER_ONE
            if(TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_CRYS_ECPKI_DomainID != CRYS_ECPKI_DomainID_secp256r1)
              continue;
          #endif
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s[test 1.%d]\n",SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name,TST_index));  
            if (TST_KeyGenType == TST_INTERNAL_KG)
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Internal Key Generation  \n"));
            else
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," External Keys  \n"));                        
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n"));


			TST_ATP_Error = SEPQA_ECC_ECDSA_IntegratedSignVerify(
				TST_KeyGenType,
				SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_CRYS_ECPKI_DomainID,
				SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPublKey,
				SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPublKeySize,
				SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPrivKey,
				SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPrivKeySize,
				SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_HashMode,
				SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_input_data,
				SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_input_dataSize,
				SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_SignitureSize,
				FailureFunctionNameOut,
				FailureFunctionName_K_Size);

			TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_ECC_ECDSA_IntegratedSignVerify",FailureFunctionNameOut,TST_MasterTestName);                   
     }/* End of TST_KeyGenType loop*/
     return TST_TestStatus;
}/*End of CRYS_ATP_TST_ECC_Acceptance_ECDSA_IntegratedSignVerify*/
/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/
/*****************************************************************************
* Function Name:                                                           
*  CRYS_ExtApp_ATP_ECC_DH      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for Diffie-Hellman key shared secret generation using ECC capabilities,
*  implemented as external SEP application  
* Algorithm:       
* 1. Call the SEPQA_ECC_DH function to execute test
* 2. Verify function succeded according to the returned error code
*
******************************************************************************/                                
CRYSError_t CRYS_ExtApp_ATP_ECC_DH  (int TST_KeyGeneration_TestStatus)
{
     CRYSError_t                            TST_TestStatus=0;
     int                                    TST_index = 0,TST_KeyGenType;
     char       TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ExtApp_ATP_ECC_DH"; 

     /* Setting if to use internal key generation */
     if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
         TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
     else
         TST_KeyGenType = TST_INTERNAL_KG;

     for (; TST_KeyGenType <2 ; TST_KeyGenType++) /*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/ 
     {
        #ifdef DX_SEP_G3_VER_ONE
            if(TST_ECC_Acceptance_DH_TestData[TST_index].TST_CRYS_ECPKI_DomainID != CRYS_ECPKI_DomainID_secp256r1)
              continue;
          #endif
            
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s[test 1.%d]\n",SEP_ECC_Acceptance_DH_TestData[TST_index].TST_Name,TST_index));  
            if (TST_KeyGenType == TST_INTERNAL_KG)
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Internal Key Generation  \n"));
            else
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," External Keys  \n"));                        
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n"));

			TST_ATP_Error = SEPQA_ECC_DH(
						TST_KeyGenType,
						SEP_ECC_Acceptance_DH_TestData[TST_index].TST_CRYS_ECPKI_DomainID,
						SEP_ECC_Acceptance_DH_TestData[TST_index].TST_ExternalPublKey1,
						SEP_ECC_Acceptance_DH_TestData[TST_index].TST_ExternalPublKey1Size,
						SEP_ECC_Acceptance_DH_TestData[TST_index].TST_ExternalPublKey2,
						SEP_ECC_Acceptance_DH_TestData[TST_index].TST_ExternalPublKey2Size,
						SEP_ECC_Acceptance_DH_TestData[TST_index].TST_ExternalPrivKey1,
						SEP_ECC_Acceptance_DH_TestData[TST_index].TST_ExternalPrivKey1Size,
						SEP_ECC_Acceptance_DH_TestData[TST_index].TST_ExternalPrivKey2,
						SEP_ECC_Acceptance_DH_TestData[TST_index].TST_ExternalPrivKey2Size,
						TST_DH_MAX_SECRET_LEN_BYTE,
						FailureFunctionNameOut,
						FailureFunctionName_K_Size);

			TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_ECC_DH",FailureFunctionNameOut,TST_MasterTestName);                   
			
     }/* End of TST_KeyGenType loop*/
     return TST_TestStatus;
}/*End of CRYS_ATP_TST_ECC_Acceptance_DH*/
/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/
/*****************************************************************************
* Function Name:                                                           
*  CRYS_ExtApp_ATP_ECC_ElGamal_EncDec      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for El-Gamal algorithm for encryption and decryption
*  implemented as external SEP application  
* Algorithm:       
* 1. Call the SEPQA_ECC_ElGamal_EncDec function to execute test
* 2. Verify function succeded according to the returned error code
*
******************************************************************************/                                
CRYSError_t CRYS_ExtApp_ATP_ECC_ElGamal_EncDec  ( int TST_KeyGeneration_TestStatus )
{
     CRYSError_t                TST_TestStatus=0;
     int                        TST_index = 0,TST_KeyGenType;
     char						TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ExtApp_ATP_ECC_ElGamal_EncDec"; 

     /* Setting if to use internal key generation */
     if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
         TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
     else
         TST_KeyGenType = TST_INTERNAL_KG;

     for (; TST_KeyGenType <2 ; TST_KeyGenType++) /*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/ 
     {
          #ifdef DX_SEP_G3_VER_ONE
            if(TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_CRYS_ECPKI_DomainID != CRYS_ECPKI_DomainID_secp256r1)
              continue;
          #endif

			/* ECC ELGAMAL functions should work only with the WMDRM domain */
			if (SEP_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_CRYS_ECPKI_DomainID != CRYS_ECPKI_DomainID_WMDRM10)
				continue;

            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s[test 1.%d]\n",SEP_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_Name,TST_index));  
            if (TST_KeyGenType == TST_INTERNAL_KG)
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Internal Key Generation  \n"));
            else
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," External Keys  \n"));                        
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n"));

			TST_ATP_Error = SEPQA_ECC_ElGamal_EncDec(
								TST_KeyGenType,
								SEP_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_CRYS_ECPKI_DomainID,
								SEP_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_ExternalPublKey,
								SEP_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_ExternalPublKeySize,
								SEP_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_ExternalPrivKey,
								SEP_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_ExternalPrivKeySize,

								SEP_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_input_data,
								SEP_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_input_dataSize,
								SEP_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_output_dataSize,
								FailureFunctionNameOut,
								FailureFunctionName_K_Size);

			TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_ECC_ElGamal_EncDec",FailureFunctionNameOut,TST_MasterTestName);                   

     }/* End of TST_KeyGenType loop*/
     return TST_TestStatus;
}/*End of CRYS_ATP_TST_ECC_Acceptance_ElGamal_EncDec*/

/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/
/*****************************************************************************
* Function Name:                                                           
*  CRYS_ExtApp_ATP_ECC_ImportExportKeyPair      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for ECC export public key functionality,
*  implemented as external SEP application  
* Algorithm:       
* 1. Call the SEPQA_ECC_ImportExportKeyPair function to execute test
* 2. Verify function succeded according to the returned error code
*
******************************************************************************/                                
CRYSError_t CRYS_ExtApp_ATP_ECC_ImportExportKeyPair  ( int TST_KeyGeneration_TestStatus)
{
     CRYSError_t   TST_TestStatus=0;    
	 int        TST_index = 0,TST_KeyGenType;
     char       TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ExtApp_ATP_ECC_ImportExportKeyPair"; 

     /* Setting if to use internal key generation */
     if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
         TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
     else
         TST_KeyGenType = TST_INTERNAL_KG;

     for (; TST_KeyGenType <2 ; TST_KeyGenType++) /*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/ 
     {
          #ifdef DX_SEP_G3_VER_ONE
            if(TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_CRYS_ECPKI_DomainID != CRYS_ECPKI_DomainID_secp256r1)
              continue;
          #endif
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s[test 1.%d]\n",SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name,TST_index));  
            if (TST_KeyGenType == TST_INTERNAL_KG)
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Internal Key Generation  \n"));
            else
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," External Keys  \n"));                        
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n"));

			TST_ATP_Error = SEPQA_ECC_ImportExportKeyPair(
								TST_KeyGenType,
								SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_CRYS_ECPKI_DomainID,
								SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPublKey,
								SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPublKeySize,
								SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPrivKey,
								SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPrivKeySize,
								SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_HashMode,                
								SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_input_data,      
								SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_input_dataSize,
								SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_SignitureSize,
								FailureFunctionNameOut,
								FailureFunctionName_K_Size);

			TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_ECC_ImportExportKeyPair",FailureFunctionNameOut,TST_MasterTestName);                   
				

          
     }/* End of TST_KeyGenType loop*/
     return TST_TestStatus;
}/*End of CRYS_ExtApp_ATP_ECC_ImportExportKeyPair*/




